<?php

require_once('SSHCommand.php');

class IPTableSetter
{
    protected $_management_server_ssh_cmd = null;

    const CHAIN_INSERT = "-I";
    const CHAIN_DELETE = "-D";

    function __construct($cfg_xml_path)
    {
        $ms_ssh_cmd_retriever = new ManagementServerSSHCmdRetriever($cfg_xml_path);
        $this->_management_server_ssh_cmd = $ms_ssh_cmd_retriever->getSSHCmd();
    }

    protected function getRejectPortCmd($port, $chain_option)
    {
        $cmd = "iptables $chain_option INPUT -p tcp --dport $port -j REJECT";
        return $cmd;
    }

    public function closePort($port)
    {
        $cmd = $this->getRejectPortCmd($port, IPTableSetter::CHAIN_INSERT);
        $this->_management_server_ssh_cmd->doCmd($cmd);
    }

    public function rollBackClosedPort($port)
    {
        $cmd = $this->getRejectPortCmd($port, IPTableSetter::CHAIN_DELETE);
        $this->_management_server_ssh_cmd->doCmd($cmd);
    }

}

class WebConsoleSwitch
{
    protected $_IPTableSetter = null;
    protected static $CONSOLE_PORT_LIST = array(80, 443, 8080);

    function __construct($cfg_xml_path)
    {
        $this->_IPTableSetter = new IPTableSetter($cfg_xml_path);
    }

    public function turnoffConsole()
    {
        foreach (WebConsoleSwitch::$CONSOLE_PORT_LIST as $port) {
            $this->_IPTableSetter->closePort($port);
        }
    }

    public function turnOnConsole()
    {
        foreach (WebConsoleSwitch::$CONSOLE_PORT_LIST as $port) {
            $this->_IPTableSetter->rollBackClosedPort($port);
        }
    }

}
